// GpPenEscP.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscP Dialog


CGpPenEscP::CGpPenEscP(CWnd* pParent /*=NULL*/)
	:CIndecatePaint(CGpPenEscP::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEscP)
	m_cLimitColor = 0;
	m_cTile = 0;
	//}}AFX_DATA_INIT

	Create(IDD,pParent);
}


void CGpPenEscP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEscP)
	DDX_CBIndex(pDX, IDC_cLimitColor, m_cLimitColor);
	DDX_CBIndex(pDX, IDC_cTile, m_cTile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEscP, CDialog)
	//{{AFX_MSG_MAP(CGpPenEscP)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEscP Message Handler

void CGpPenEscP::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}


CContents*  CGpPenEscP::CreateContents()
{
	// Create empty content
	CContentsEscP* pContents = new CContentsEscP();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	// Tile Pattern
	pContents->m_Data.cTile = m_cTile ;

	// EF
	pContents->m_Data.cLimitColor = m_cLimitColor ;


	// Set Content the display position
	pContents->m_Data.iX1 = m_iX1 ;
	pContents->m_Data.iY1 = m_iY1 ;
	return( pContents );
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Draw paint
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Erase drawing
void CIndecatePaint::ActionErase(CDC* pDC)
{
	if( m_bAction ){
		InvertPaintMark(pDC,m_iX1,m_iY1);
		m_bAction = FALSE ;
	}
}

// Draw to the new position
void CIndecatePaint::ActionDisplay(CPoint NewPoint,CDC* pDC)
{
	// Erase
	ActionErase(pDC);

	// Draw at new position
	m_iX1 = NewPoint.x ;
	m_iY1 = NewPoint.y ;
	InvertPaintMark(pDC,m_iX1,m_iY1);
	m_bAction = TRUE ;
}


// Start Drawing
int  CIndecatePaint::ActionDown(UINT nFlags, CPoint point,CDC* pDC)
{
	// Draw
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}


// Move
int  CIndecatePaint::ActionMove(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	return( B_ActionContinue );	// Continue
}

// End
int  CIndecatePaint::ActionUp(UINT nFlags, CPoint point,CDC* pDC)
{
	ActionDisplay(point,pDC) ;

	ActionErase(pDC) ;

	return( B_ActionOk );
}

// Cancel
int  CIndecatePaint::ActionCancel(CDC* pDC)
{
	ActionErase(pDC) ;

	return( B_ActionStop );
}
